/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.AtCommandResponse;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum AssociationStatus {
    SUCCESS(0, "Successful completion - Coordinator started or Router/End Device found and joined with a parent."),
    NO_PAN(33, "Scan found no PANs"),
    NO_VALID_PAN(34, "Scan found no valid PANs based on current SC and ID settings"),
    NJ_EXPIRED(35, "Valid Coordinator or Routers found, but they are not allowing joining (NJ expired)"),
    NJ_FAILED(39, "Node Joining attempt failed (typically due to incompatible security settings)"),
    COORDINATOR_START_FAILED(42, "Coordinator Start attempt failed"),
    SCANNING_FOR_PARENT(255, "Scanning for a Parent"),
    EXISTING_COORDINATOR_CHECK(43, "Checking for an existing coordinator");

    private static final Map<Integer, AssociationStatus> lookup;
    private final int value;
    private final String description;

    public static AssociationStatus get(int value) {
        return lookup.get(value);
    }

    public static AssociationStatus get(AtCommandResponse response) {
        return AssociationStatus.get(response.getValue()[0]);
    }

    private AssociationStatus(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        lookup = new HashMap<Integer, AssociationStatus>();
        for (AssociationStatus s : EnumSet.allOf(AssociationStatus.class)) {
            lookup.put(s.getValue(), s);
        }
    }
}

