/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.IntArrayInputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZBNodeDiscover {
    private static final Logger log = Logger.getLogger(ZBNodeDiscover.class);
    private XBeeAddress16 nodeAddress16;
    private XBeeAddress64 nodeAddress64;
    private String nodeIdentifier;
    private XBeeAddress16 parent;
    private DeviceType deviceType;
    private int status;
    private int[] profileId;
    private int[] mfgId;

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int[] getProfileId() {
        return this.profileId;
    }

    public void setProfileId(int[] profileId) {
        this.profileId = profileId;
    }

    public int[] getMfgId() {
        return this.mfgId;
    }

    public void setMfgId(int[] mfgId) {
        this.mfgId = mfgId;
    }

    public static ZBNodeDiscover parse(AtCommandResponse response) {
        int ch;
        if (!response.getCommand().equals("ND")) {
            throw new RuntimeException("This method is only applicable for the ND command");
        }
        int[] data = response.getValue();
        IntArrayInputStream in = new IntArrayInputStream(data);
        ZBNodeDiscover nd = new ZBNodeDiscover();
        nd.setNodeAddress16(new XBeeAddress16(in.read(2)));
        nd.setNodeAddress64(new XBeeAddress64(in.read(8)));
        StringBuffer ni = new StringBuffer();
        while ((ch = in.read()) != 0) {
            if (ch < 32 || ch > 126) {
                throw new RuntimeException("Node Identifier " + ch + " is non-ascii");
            }
            ni.append((char)ch);
        }
        nd.setNodeIdentifier(ni.toString());
        nd.setParent(new XBeeAddress16(in.read(2)));
        nd.setDeviceType(DeviceType.get(in.read()));
        nd.setStatus(in.read());
        nd.setProfileId(in.read(2));
        nd.setMfgId(in.read(2));
        return nd;
    }

    public String toString() {
        return "nodeAddress16=" + this.nodeAddress16 + ", nodeAddress64=" + this.nodeAddress64 + ", nodeIdentifier=" + this.nodeIdentifier + ", parentAddress=" + this.getParent() + ", deviceType=" + (Object)((Object)this.deviceType) + ", status=" + this.status + ", profileId=" + ByteUtils.toBase16(this.profileId) + ", mfgId=" + ByteUtils.toBase16(this.mfgId);
    }

    public XBeeAddress16 getNodeAddress16() {
        return this.nodeAddress16;
    }

    public void setNodeAddress16(XBeeAddress16 my) {
        this.nodeAddress16 = my;
    }

    public XBeeAddress64 getNodeAddress64() {
        return this.nodeAddress64;
    }

    public void setNodeAddress64(XBeeAddress64 serial) {
        this.nodeAddress64 = serial;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public XBeeAddress16 getParent() {
        return this.parent;
    }

    public void setParent(XBeeAddress16 parent) {
        this.parent = parent;
    }

    public static enum DeviceType {
        DEV_TYPE_COORDINATOR(0),
        DEV_TYPE_ROUTER(1),
        DEV_TYPE_END_DEVICE(2);

        private static final Map<Integer, DeviceType> lookup;
        private final int value;

        public static DeviceType get(int value) {
            return lookup.get(value);
        }

        private DeviceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, DeviceType>();
            for (DeviceType s : EnumSet.allOf(DeviceType.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

