/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.zigbee.ZNetRxResponse;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.DoubleByte;
import java.io.IOException;

public class ZNetExplicitRxResponse
extends ZNetRxResponse {
    private int sourceEndpoint;
    private int destinationEndpoint;
    private DoubleByte clusterId;
    private DoubleByte profileId;

    public int getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public void setSourceEndpoint(int sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    public int getDestinationEndpoint() {
        return this.destinationEndpoint;
    }

    public void setDestinationEndpoint(int destinationEndpoint) {
        this.destinationEndpoint = destinationEndpoint;
    }

    public DoubleByte getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(DoubleByte clusterId) {
        this.clusterId = clusterId;
    }

    public DoubleByte getProfileId() {
        return this.profileId;
    }

    public void setProfileId(DoubleByte profileId) {
        this.profileId = profileId;
    }

    @Override
    public void parse(IPacketParser parser) throws IOException {
        this.parseAddress(parser);
        this.setSourceEndpoint(parser.read("Reading Source Endpoint"));
        this.setDestinationEndpoint(parser.read("Reading Destination Endpoint"));
        DoubleByte clusterId = new DoubleByte();
        clusterId.setMsb(parser.read("Reading Cluster Id MSB"));
        clusterId.setLsb(parser.read("Reading Cluster Id LSB"));
        this.setClusterId(clusterId);
        DoubleByte profileId = new DoubleByte();
        profileId.setMsb(parser.read("Reading Profile Id MSB"));
        profileId.setLsb(parser.read("Reading Profile Id LSB"));
        this.setProfileId(profileId);
        this.parseOption(parser);
        this.setData(parser.readRemainingBytes());
    }

    @Override
    public String toString() {
        return super.toString() + ",sourceEndpoint=" + ByteUtils.toBase16(this.getSourceEndpoint()) + ",destinationEndpoint=" + ByteUtils.toBase16(this.getDestinationEndpoint()) + ",clusterId(msb)=" + ByteUtils.toBase16(this.getClusterId().getMsb()) + ",clusterId(lsb)=" + ByteUtils.toBase16(this.getClusterId().getLsb()) + ",profileId(msb)=" + ByteUtils.toBase16(this.getProfileId().getMsb()) + ",profileId(lsb)=" + ByteUtils.toBase16(this.getProfileId().getLsb());
    }
}

