/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.zigbee.ZNetTxRequest;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.DoubleByte;
import com.rapplogic.xbee.util.IntArrayOutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ZNetExplicitTxRequest
extends ZNetTxRequest {
    private int sourceEndpoint;
    private int destinationEndpoint;
    private DoubleByte clusterId;
    private DoubleByte profileId;
    public static final DoubleByte znetProfileId = new DoubleByte(193, 5);
    public static final DoubleByte zdoProfileId = new DoubleByte(0, 0);

    public ZNetExplicitTxRequest(int frameId, XBeeAddress64 dest64, XBeeAddress16 dest16, int broadcastRadius, ZNetTxRequest.Option option, int[] payload, int sourceEndpoint, int destinationEndpoint, DoubleByte clusterId, DoubleByte profileId) {
        super(frameId, dest64, dest16, broadcastRadius, option, payload);
        this.sourceEndpoint = sourceEndpoint;
        this.destinationEndpoint = destinationEndpoint;
        this.clusterId = clusterId;
        this.profileId = profileId;
    }

    @Override
    public int[] getFrameData() {
        IntArrayOutputStream frameData = this.getFrameDataAsIntArrayOutputStream();
        frameData.getInternalList().set(0, this.getApiId().getValue());
        frameData.getInternalList().add(12, this.getSourceEndpoint());
        frameData.getInternalList().add(13, this.getDestinationEndpoint());
        frameData.getInternalList().add(14, this.getClusterId().getMsb());
        frameData.getInternalList().add(15, this.getClusterId().getLsb());
        frameData.getInternalList().add(16, this.getProfileId().getMsb());
        frameData.getInternalList().add(17, this.getProfileId().getLsb());
        return frameData.getIntArray();
    }

    @Override
    public ApiId getApiId() {
        return ApiId.ZNET_EXPLICIT_TX_REQUEST;
    }

    public int getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public void setSourceEndpoint(int sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    public int getDestinationEndpoint() {
        return this.destinationEndpoint;
    }

    public void setDestinationEndpoint(int destinationEndpoint) {
        this.destinationEndpoint = destinationEndpoint;
    }

    public DoubleByte getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(DoubleByte clusterId) {
        this.clusterId = clusterId;
    }

    public DoubleByte getProfileId() {
        return this.profileId;
    }

    public void setProfileId(DoubleByte profileId) {
        this.profileId = profileId;
    }

    @Override
    public String toString() {
        return super.toString() + ",sourceEndpoint=" + ByteUtils.toBase16(this.getSourceEndpoint()) + ",destinationEndpoint=" + ByteUtils.toBase16(this.getDestinationEndpoint()) + ",clusterId(msb)=" + ByteUtils.toBase16(this.getClusterId().getMsb()) + ",clusterId(lsb)=" + ByteUtils.toBase16(this.getClusterId().getLsb()) + ",profileId(msb)=" + ByteUtils.toBase16(this.getProfileId().getMsb()) + ",profileId(lsb)=" + ByteUtils.toBase16(this.getProfileId().getLsb());
    }

    public static enum ClusterId {
        TRANSPARENT_SERIAL(Endpoint.DATA, 17),
        SERIAL_LOOPBACK(Endpoint.DATA, 18),
        IO_SAMPLE(Endpoint.DATA, 146),
        XBEE_SENSOR(Endpoint.DATA, 148),
        NODE_IDENTIFICATION(Endpoint.DATA, 149);

        private static final Map<Integer, ClusterId> lookup;
        private final int value;
        private final Endpoint endpoint;

        public static ClusterId get(int value) {
            return lookup.get(value);
        }

        private ClusterId(Endpoint endpoint, int value) {
            this.endpoint = endpoint;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        static {
            lookup = new HashMap<Integer, ClusterId>();
            for (ClusterId s : EnumSet.allOf(ClusterId.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }

    public static enum Endpoint {
        ZDO_ENDPOINT(0),
        COMMAND(230),
        DATA(232);

        private static final Map<Integer, Endpoint> lookup;
        private final int value;

        public static Endpoint get(int value) {
            return lookup.get(value);
        }

        private Endpoint(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, Endpoint>();
            for (Endpoint s : EnumSet.allOf(Endpoint.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

