/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZNetRxBaseResponse;
import com.rapplogic.xbee.util.DoubleByte;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZNetNodeIdentificationResponse
extends XBeeResponse {
    private static final Logger log = Logger.getLogger(ZNetNodeIdentificationResponse.class);
    private XBeeAddress64 remoteAddress64;
    private XBeeAddress16 remoteAddress16;
    private ZNetRxBaseResponse.Option option;
    private XBeeAddress64 remoteAddress64_2;
    private XBeeAddress16 remoteAddress16_2;
    private String nodeIdentifier;
    private XBeeAddress16 parentAddress;
    private DeviceType deviceType;
    private SourceAction sourceAction;
    private DoubleByte profileId;
    private DoubleByte mfgId;

    public XBeeAddress64 getRemoteAddress64() {
        return this.remoteAddress64;
    }

    public void setRemoteAddress64(XBeeAddress64 remoteAddress64) {
        this.remoteAddress64 = remoteAddress64;
    }

    public XBeeAddress16 getRemoteAddress16() {
        return this.remoteAddress16;
    }

    public void setRemoteAddress16(XBeeAddress16 remoteAddress16) {
        this.remoteAddress16 = remoteAddress16;
    }

    public ZNetRxBaseResponse.Option getOption() {
        return this.option;
    }

    public void setOption(ZNetRxBaseResponse.Option option) {
        this.option = option;
    }

    public XBeeAddress64 getRemoteAddress64_2() {
        return this.remoteAddress64_2;
    }

    public void setRemoteAddress64_2(XBeeAddress64 remoteAddress64_2) {
        this.remoteAddress64_2 = remoteAddress64_2;
    }

    public XBeeAddress16 getRemoteAddress16_2() {
        return this.remoteAddress16_2;
    }

    public void setRemoteAddress16_2(XBeeAddress16 remoteAddress16_2) {
        this.remoteAddress16_2 = remoteAddress16_2;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public XBeeAddress16 getParentAddress() {
        return this.parentAddress;
    }

    public void setParentAddress(XBeeAddress16 parentAddress) {
        this.parentAddress = parentAddress;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public SourceAction getSourceAction() {
        return this.sourceAction;
    }

    public void setSourceAction(SourceAction sourceAction) {
        this.sourceAction = sourceAction;
    }

    public DoubleByte getProfileId() {
        return this.profileId;
    }

    public void setProfileId(DoubleByte profileId) {
        this.profileId = profileId;
    }

    public DoubleByte getMfgId() {
        return this.mfgId;
    }

    public void setMfgId(DoubleByte mfgId) {
        this.mfgId = mfgId;
    }

    @Override
    public void parse(IPacketParser parser) throws IOException {
        this.setRemoteAddress64(parser.parseAddress64());
        this.setRemoteAddress16(parser.parseAddress16());
        int option = parser.read("Option");
        this.setOption(ZNetRxBaseResponse.getOption(option));
        this.setRemoteAddress16_2(parser.parseAddress16());
        this.setRemoteAddress64_2(parser.parseAddress64());
        StringBuffer ni = new StringBuffer();
        int ch = 0;
        while ((ch = parser.read("Node Identifier")) != 0) {
            ni.append((char)ch);
        }
        this.setNodeIdentifier(ni.toString());
        this.setParentAddress(parser.parseAddress16());
        int deviceType = parser.read("Device Type");
        if (DeviceType.get(deviceType) != null) {
            this.setDeviceType(DeviceType.get(deviceType));
        } else {
            log.warn((Object)("Unknown device type " + deviceType));
            this.setDeviceType(DeviceType.UNKNOWN);
        }
        int sourceAction = parser.read("Source Action");
        if (SourceAction.get(sourceAction) != null) {
            this.setSourceAction(SourceAction.get(sourceAction));
        } else {
            log.warn((Object)("Unknown source event " + sourceAction));
            this.setSourceAction(SourceAction.UNKNOWN);
        }
        DoubleByte profileId = new DoubleByte();
        profileId.setMsb(parser.read("Profile MSB"));
        profileId.setLsb(parser.read("Profile LSB"));
        this.setProfileId(profileId);
        DoubleByte mfgId = new DoubleByte();
        mfgId.setMsb(parser.read("MFG MSB"));
        mfgId.setLsb(parser.read("MFG LSB"));
        this.setMfgId(mfgId);
    }

    @Override
    public String toString() {
        return "ZNetNodeIdentificationResponse [deviceType=" + (Object)((Object)this.deviceType) + ", mfgId=" + this.mfgId + ", nodeIdentifier=" + this.nodeIdentifier + ", option=" + (Object)((Object)this.option) + ", parentAddress=" + this.parentAddress + ", profileId=" + this.profileId + ", remoteAddress16=" + this.remoteAddress16 + ", remoteAddress16_2=" + this.remoteAddress16_2 + ", remoteAddress64=" + this.remoteAddress64 + ", remoteAddress64_2=" + this.remoteAddress64_2 + ", sourceAction=" + (Object)((Object)this.sourceAction) + "]" + super.toString();
    }

    public static enum SourceAction {
        PUSHBUTTON(1),
        JOINING(2),
        POWER_CYCLE(3),
        UNKNOWN(-1);

        private static final Map<Integer, SourceAction> lookup;
        private final int value;

        public static SourceAction get(int value) {
            return lookup.get(value);
        }

        private SourceAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, SourceAction>();
            for (SourceAction s : EnumSet.allOf(SourceAction.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }

    public static enum DeviceType {
        COORDINATOR(1),
        ROUTER(2),
        END_DEVICE(3),
        UNKNOWN(-1);

        private static final Map<Integer, DeviceType> lookup;
        private final int value;

        public static DeviceType get(int value) {
            return lookup.get(value);
        }

        private DeviceType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, DeviceType>();
            for (DeviceType s : EnumSet.allOf(DeviceType.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

