/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ZNetRxBaseResponse
extends XBeeResponse {
    private static final Logger log = Logger.getLogger(ZNetRxBaseResponse.class);
    private XBeeAddress64 remoteAddress64;
    private XBeeAddress16 remoteAddress16;
    private Option option;

    public XBeeAddress64 getRemoteAddress64() {
        return this.remoteAddress64;
    }

    public void setRemoteAddress64(XBeeAddress64 remoteAddress64) {
        this.remoteAddress64 = remoteAddress64;
    }

    public XBeeAddress16 getRemoteAddress16() {
        return this.remoteAddress16;
    }

    public void setRemoteAddress16(XBeeAddress16 remoteAddress16) {
        this.remoteAddress16 = remoteAddress16;
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    protected void parseAddress(IPacketParser parser) throws IOException {
        this.setRemoteAddress64(parser.parseAddress64());
        this.setRemoteAddress16(parser.parseAddress16());
    }

    protected static Option getOption(int option) {
        if (Option.get(option) != null) {
            return Option.get(option);
        }
        log.warn((Object)("Unknown response option " + option));
        return Option.UNKNOWN;
    }

    protected void parseOption(IPacketParser parser) throws IOException {
        int option = parser.read("ZNet RX Response Option");
        this.setOption(ZNetRxBaseResponse.getOption(option));
    }

    @Override
    public String toString() {
        return super.toString() + ",remoteAddress64=" + this.remoteAddress64 + ",remoteAddress16=" + this.remoteAddress16 + ",option=" + (Object)((Object)this.option);
    }

    public static enum Option {
        PACKET_ACKNOWLEDGED(1),
        BROADCAST_PACKET(2),
        PACKET_ENCRYPTED_WITH_APS(32),
        PACKET_SENT_FROM_END_DEVICE(64),
        PACKET_ACKNOWLEDGED_0x21(33),
        PACKET_ACKNOWLEDGED_0x41(65),
        PACKET_ACKNOWLEDGED_0x61(97),
        PACKET_ENCRYPTED_WITH_APS_PACKET_SENT_FROM_END_DEVICE(96),
        BROADCAST_PACKET_0x22(34),
        BROADCAST_PACKET_0x42(66),
        BROADCAST_PACKET_0x62(98),
        UNKNOWN(-1);

        private static final Map<Integer, Option> lookup;
        private final int value;

        public static Option get(int value) {
            return lookup.get(value);
        }

        private Option(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, Option>();
            for (Option s : EnumSet.allOf(Option.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

