/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.NoRequestResponse;
import com.rapplogic.xbee.api.XBeeParseException;
import com.rapplogic.xbee.api.zigbee.ZNetRxBaseResponse;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.IIntInputStream;
import com.rapplogic.xbee.util.IntArrayInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ZNetRxIoSampleResponse
extends ZNetRxBaseResponse
implements NoRequestResponse {
    private static final Logger log = Logger.getLogger(ZNetRxIoSampleResponse.class);
    private int digitalChannelMaskMsb;
    private int digitalChannelMaskLsb;
    private int analogChannelMask;
    private Integer dioMsb;
    private Integer dioLsb;
    private static final int SUPPLY_VOLTAGE_INDEX = 4;
    private Integer[] analog = new Integer[5];

    public static ZNetRxIoSampleResponse parseIsSample(AtCommandResponse response) throws IOException {
        if (!response.getCommand().equals("IS")) {
            throw new RuntimeException("This is only applicable to the \"IS\" AT command");
        }
        IntArrayInputStream in = new IntArrayInputStream(response.getValue());
        ZNetRxIoSampleResponse sample = new ZNetRxIoSampleResponse();
        sample.parseIoSample(in);
        return sample;
    }

    @Override
    public void parse(IPacketParser parser) throws IOException {
        this.parseAddress(parser);
        this.parseOption(parser);
        this.parseIoSample((IIntInputStream)((Object)parser));
    }

    public void parseIoSample(IIntInputStream parser) throws IOException {
        int size = parser.read("ZNet RX IO Sample Size");
        if (size != 1) {
            throw new XBeeParseException("Sample size is not supported if > 1 for ZNet I/O");
        }
        this.setDigitalChannelMaskMsb(parser.read("ZNet RX IO Sample Digital Mask 1"));
        this.setDigitalChannelMaskLsb(parser.read("ZNet RX IO Sample Digital Mask 2"));
        this.setAnalogChannelMask(parser.read("ZNet RX IO Sample Analog Channel Mask"));
        this.analogChannelMask &= 0x8F;
        this.digitalChannelMaskMsb &= 0x1C;
        if (this.containsDigital()) {
            log.info((Object)"response contains digital data");
            this.setDioMsb(parser.read("ZNet RX IO DIO MSB"));
            this.setDioLsb(parser.read("ZNet RX IO DIO LSB"));
        } else {
            log.info((Object)"response does not contain digital data");
        }
        int enabledCount = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.isAnalogEnabled(i)) continue;
            log.info((Object)("response contains analog[" + i + "]"));
            this.analog[i] = ByteUtils.parse10BitAnalog(parser, enabledCount);
            ++enabledCount;
        }
        if (this.isSupplyVoltageEnabled()) {
            this.analog[4] = ByteUtils.parse10BitAnalog(parser, enabledCount);
            ++enabledCount;
        }
        log.debug((Object)("There are " + this.analog + " analog inputs in this packet"));
    }

    public int getDigitalChannelMaskMsb() {
        return this.digitalChannelMaskMsb;
    }

    private void setDigitalChannelMaskMsb(int digitalChannelMask1) {
        this.digitalChannelMaskMsb = digitalChannelMask1;
    }

    public int getDigitalChannelMaskLsb() {
        return this.digitalChannelMaskLsb;
    }

    private void setDigitalChannelMaskLsb(int digitalChannelMask2) {
        this.digitalChannelMaskLsb = digitalChannelMask2;
    }

    public int getAnalogChannelMask() {
        return this.analogChannelMask;
    }

    private void setAnalogChannelMask(int analogChannelMask) {
        this.analogChannelMask = analogChannelMask;
    }

    public boolean isD0Enabled() {
        return this.isDigitalEnabled(0);
    }

    public boolean isD1Enabled() {
        return this.isDigitalEnabled(1);
    }

    public boolean isD2Enabled() {
        return this.isDigitalEnabled(2);
    }

    public boolean isD3Enabled() {
        return this.isDigitalEnabled(3);
    }

    public boolean isD4Enabled() {
        return this.isDigitalEnabled(4);
    }

    public boolean isD5Enabled() {
        return this.isDigitalEnabled(5);
    }

    public boolean isD6Enabled() {
        return this.isDigitalEnabled(6);
    }

    public boolean isD7Enabled() {
        return this.isDigitalEnabled(7);
    }

    public boolean isD10Enabled() {
        return this.isDigitalEnabled(10);
    }

    public boolean isD11Enabled() {
        return this.isDigitalEnabled(11);
    }

    public boolean isD12Enabled() {
        return this.isDigitalEnabled(12);
    }

    public boolean isA0Enabled() {
        return this.isAnalogEnabled(0);
    }

    public boolean isA1Enabled() {
        return this.isAnalogEnabled(1);
    }

    public boolean isA2Enabled() {
        return this.isAnalogEnabled(2);
    }

    public boolean isA3Enabled() {
        return this.isAnalogEnabled(3);
    }

    public boolean isDigitalEnabled(int pin) {
        if (pin >= 0 && pin <= 7) {
            return ByteUtils.getBit(this.digitalChannelMaskLsb, pin + 1);
        }
        if (pin >= 10 && pin <= 12) {
            return ByteUtils.getBit(this.digitalChannelMaskMsb, pin - 7);
        }
        throw new IllegalArgumentException("Unsupported pin: " + pin);
    }

    public boolean isAnalogEnabled(int pin) {
        if (pin >= 0 && pin <= 3) {
            return ByteUtils.getBit(this.analogChannelMask, pin + 1);
        }
        throw new IllegalArgumentException("Unsupported pin: " + pin);
    }

    public boolean isSupplyVoltageEnabled() {
        return ByteUtils.getBit(this.analogChannelMask, 8);
    }

    public Boolean isD0On() {
        if (this.isDigitalEnabled(0)) {
            return this.isDigitalOn(0);
        }
        return null;
    }

    public Boolean isD1On() {
        if (this.isDigitalEnabled(1)) {
            return this.isDigitalOn(1);
        }
        return null;
    }

    public Boolean isD2On() {
        if (this.isDigitalEnabled(2)) {
            return this.isDigitalOn(2);
        }
        return null;
    }

    public Boolean isD3On() {
        if (this.isDigitalEnabled(3)) {
            return this.isDigitalOn(3);
        }
        return null;
    }

    public Boolean isD4On() {
        if (this.isDigitalEnabled(4)) {
            return this.isDigitalOn(4);
        }
        return null;
    }

    public Boolean isD5On() {
        if (this.isDigitalEnabled(5)) {
            return this.isDigitalOn(5);
        }
        return null;
    }

    public Boolean isD6On() {
        if (this.isDigitalEnabled(6)) {
            return this.isDigitalOn(6);
        }
        return null;
    }

    public Boolean isD7On() {
        if (this.isDigitalEnabled(7)) {
            return this.isDigitalOn(7);
        }
        return null;
    }

    public Boolean isD10On() {
        if (this.isDigitalEnabled(10)) {
            return this.isDigitalOn(10);
        }
        return null;
    }

    public Boolean isD11On() {
        if (this.isDigitalEnabled(11)) {
            return this.isDigitalOn(11);
        }
        return null;
    }

    public Boolean isD12On() {
        if (this.isDigitalEnabled(12)) {
            return this.isDigitalOn(12);
        }
        return null;
    }

    public Boolean isDigitalOn(int pin) {
        if (this.isDigitalEnabled(pin)) {
            if (pin >= 0 && pin <= 7) {
                return ByteUtils.getBit(this.dioLsb, pin + 1);
            }
            if (pin >= 10 && pin <= 12) {
                return ByteUtils.getBit(this.dioMsb, pin - 7);
            }
        }
        return null;
    }

    public boolean containsDigital() {
        return this.getDigitalChannelMaskMsb() > 0 || this.getDigitalChannelMaskLsb() > 0;
    }

    public boolean containsAnalog() {
        return this.getAnalogChannelMask() > 0;
    }

    public Integer getDioMsb() {
        return this.dioMsb;
    }

    private void setDioMsb(Integer dioMsb) {
        this.dioMsb = dioMsb;
    }

    public Integer getDioLsb() {
        return this.dioLsb;
    }

    private void setDioLsb(Integer dioLsb) {
        this.dioLsb = dioLsb;
    }

    public Integer getAnalog0() {
        return this.analog[0];
    }

    public void setAnalog0(Integer analog0) {
        this.analog[0] = analog0;
    }

    public Integer getAnalog1() {
        return this.analog[1];
    }

    public void setAnalog1(Integer analog1) {
        this.analog[1] = analog1;
    }

    public Integer getAnalog2() {
        return this.analog[2];
    }

    public void setAnalog2(Integer analog2) {
        this.analog[2] = analog2;
    }

    public Integer getAnalog3() {
        return this.analog[3];
    }

    public void setAnalog3(Integer analog3) {
        this.analog[3] = analog3;
    }

    public Integer getAnalog(int pin) {
        if (this.isAnalogEnabled(pin)) {
            return this.analog[pin];
        }
        return null;
    }

    public Integer getSupplyVoltage() {
        return this.analog[4];
    }

    public void setSupplyVoltage(Integer supplyVoltage) {
        this.analog[4] = supplyVoltage;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        if (this.containsDigital()) {
            for (i = 0; i <= 7; ++i) {
                if (!this.isDigitalEnabled(i)) continue;
                builder.append(",digital[" + i + "]=" + (this.isDigitalOn(i) != false ? "high" : "low"));
            }
            for (i = 10; i <= 12; ++i) {
                if (!this.isDigitalEnabled(i)) continue;
                builder.append(",digital[" + i + "]=" + (this.isDigitalOn(i) != false ? "high" : "low"));
            }
        }
        if (this.containsAnalog()) {
            for (i = 0; i <= 3; ++i) {
                if (!this.isAnalogEnabled(i)) continue;
                builder.append(",analog[" + i + "]=" + this.getAnalog(i));
            }
            if (this.isSupplyVoltageEnabled()) {
                builder.append(",supplyVoltage=" + this.getSupplyVoltage());
            }
        }
        return builder.toString();
    }
}

