/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeRequest;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.IntArrayOutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ZNetTxRequest
extends XBeeRequest {
    public static final int ZNET_MAX_PAYLOAD_SIZE = 72;
    public static final int DEFAULT_BROADCAST_RADIUS = 0;
    private XBeeAddress64 destAddr64;
    private XBeeAddress16 destAddr16;
    private int broadcastRadius;
    private Option option;
    private int[] payload;
    private int maxPayloadSize;

    public ZNetTxRequest(int frameId, XBeeAddress64 dest64, XBeeAddress16 dest16, int broadcastRadius, Option option, int[] payload) {
        this.setFrameId(frameId);
        this.destAddr64 = dest64;
        this.destAddr16 = dest16;
        this.broadcastRadius = broadcastRadius;
        this.option = option;
        this.payload = payload;
    }

    public ZNetTxRequest(XBeeAddress64 dest64, int[] payload) {
        this(1, dest64, XBeeAddress16.ZNET_BROADCAST, 0, Option.UNICAST, payload);
    }

    protected IntArrayOutputStream getFrameDataAsIntArrayOutputStream() {
        if (this.getMaxPayloadSize() > 0 && this.payload.length > this.getMaxPayloadSize()) {
            throw new IllegalArgumentException("Payload exceeds user-defined maximum payload size of " + this.getMaxPayloadSize() + " bytes.  Please package into multiple packets");
        }
        IntArrayOutputStream out = new IntArrayOutputStream();
        out.write(this.getApiId().getValue());
        out.write(this.getFrameId());
        out.write(this.destAddr64.getAddress());
        out.write(this.destAddr16.getAddress());
        out.write(this.broadcastRadius);
        out.write(this.option.getValue());
        out.write(this.payload);
        return out;
    }

    @Override
    public int[] getFrameData() {
        return this.getFrameDataAsIntArrayOutputStream().getIntArray();
    }

    @Override
    public ApiId getApiId() {
        return ApiId.ZNET_TX_REQUEST;
    }

    public XBeeAddress64 getDestAddr64() {
        return this.destAddr64;
    }

    public void setDestAddr64(XBeeAddress64 destAddr64) {
        this.destAddr64 = destAddr64;
    }

    public XBeeAddress16 getDestAddr16() {
        return this.destAddr16;
    }

    public void setDestAddr16(XBeeAddress16 destAddr16) {
        this.destAddr16 = destAddr16;
    }

    public int getBroadcastRadius() {
        return this.broadcastRadius;
    }

    public void setBroadcastRadius(int broadcastRadius) {
        this.broadcastRadius = broadcastRadius;
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    public int[] getPayload() {
        return this.payload;
    }

    public void setPayload(int[] payload) {
        this.payload = payload;
    }

    @Override
    public String toString() {
        return super.toString() + ",destAddr64=" + this.destAddr64 + ",destAddr16=" + this.destAddr16 + ",broadcastRadius=" + this.broadcastRadius + ",option=" + (Object)((Object)this.option) + ",payload=" + ByteUtils.toBase16(this.payload);
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public void setMaxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    public static enum Option {
        UNICAST(0),
        BROADCAST(8),
        DISABLE_RETRIES(1),
        ENABLE_APS_ENCRYPTION(32),
        USE_EXTENDED_TIMEOUT(64);

        private static final Map<Integer, Option> lookup;
        private final int value;

        public static Option get(int value) {
            return lookup.get(value);
        }

        private Option(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, Option>();
            for (Option s : EnumSet.allOf(Option.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

