/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.zigbee;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeFrameIdResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZNetTxStatusResponse
extends XBeeFrameIdResponse {
    private static final Logger log = Logger.getLogger(ZNetTxStatusResponse.class);
    private XBeeAddress16 remoteAddress16;
    private int retryCount;
    private DeliveryStatus deliveryStatus;
    private DiscoveryStatus discoveryStatus;

    public XBeeAddress16 getRemoteAddress16() {
        return this.remoteAddress16;
    }

    public void setRemoteAddress16(XBeeAddress16 remoteAddress) {
        this.remoteAddress16 = remoteAddress;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public DeliveryStatus getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public void setDeliveryStatus(DeliveryStatus deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public DiscoveryStatus getDiscoveryStatus() {
        return this.discoveryStatus;
    }

    public void setDiscoveryStatus(DiscoveryStatus discoveryStatus) {
        this.discoveryStatus = discoveryStatus;
    }

    public boolean isSuccess() {
        return this.getDeliveryStatus() == DeliveryStatus.SUCCESS;
    }

    @Override
    public void parse(IPacketParser parser) throws IOException {
        this.setFrameId(parser.read("ZNet Tx Status Frame Id"));
        this.setRemoteAddress16(parser.parseAddress16());
        this.setRetryCount(parser.read("ZNet Tx Status Tx Count"));
        int deliveryStatus = parser.read("ZNet Tx Status Delivery Status");
        if (DeliveryStatus.get(deliveryStatus) != null) {
            this.setDeliveryStatus(DeliveryStatus.get(deliveryStatus));
        } else {
            log.warn((Object)("Unknown delivery status " + deliveryStatus));
            this.setDeliveryStatus(DeliveryStatus.UNKNOWN);
        }
        int discoveryStatus = parser.read("ZNet Tx Status Discovery Status");
        if (DiscoveryStatus.get(discoveryStatus) != null) {
            this.setDiscoveryStatus(DiscoveryStatus.get(discoveryStatus));
        } else {
            log.warn((Object)("Unknown discovery status " + discoveryStatus));
            this.setDiscoveryStatus(DiscoveryStatus.UNKNOWN);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ",remoteAddress16=" + this.remoteAddress16 + ",retryCount=" + this.retryCount + ",deliveryStatus=" + (Object)((Object)this.deliveryStatus) + ",discoveryStatus=" + (Object)((Object)this.discoveryStatus);
    }

    public static enum DiscoveryStatus {
        NO_DISCOVERY(0),
        ADDRESS_DISCOVERY(1),
        ROUTE_DISCOVERY(2),
        ADDRESS_AND_ROUTE_DISCOVERY(3),
        EXTENDED_TIMEOUT_DISCOVERY(64),
        EXTENDED_TIMEOUT_DISCOVERY_0x41(65),
        EXTENDED_TIMEOUT_DISCOVERY_0x42(66),
        EXTENDED_TIMEOUT_DISCOVERY_0x43(67),
        UNKNOWN(-1);

        private static final Map<Integer, DiscoveryStatus> lookup;
        private final int value;

        private DiscoveryStatus(int value) {
            this.value = value;
        }

        public static DiscoveryStatus get(int value) {
            return lookup.get(value);
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, DiscoveryStatus>();
            for (DiscoveryStatus s : EnumSet.allOf(DiscoveryStatus.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }

    public static enum DeliveryStatus {
        SUCCESS(0),
        MAC_FAILURE(1),
        CCA_FAILURE(2),
        INVALID_DESTINATION_ENDPOINT(21),
        NETWORK_ACK_FAILURE(33),
        NOT_JOINED_TO_NETWORK(34),
        SELF_ADDRESSED(35),
        ADDRESS_NOT_FOUND(36),
        ROUTE_NOT_FOUND(37),
        BROADCAST_SOURCE_NEIGHBOR_FAILURE(38),
        INVALID_BINDING_TABLE_INDEX(43),
        RESOURCE_ERROR_LACK_FREE_BUFFERS(44),
        ATTEMPTED_BROADCAST_WITH_APS_TX(45),
        ATTEMPTED_UNICAST_WITH_APS_TX_EE_ZERO(46),
        RESOURCE_ERROR_LACK_FREE_BUFFERS_0x32(50),
        PAYLOAD_TOO_LARGE(116),
        UNKNOWN(-1);

        private static final Map<Integer, DeliveryStatus> lookup;
        private final int value;

        private DeliveryStatus(int value) {
            this.value = value;
        }

        public static DeliveryStatus get(int value) {
            return lookup.get(value);
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, DeliveryStatus>();
            for (DeliveryStatus s : EnumSet.allOf(DeliveryStatus.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

