/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples;

import com.rapplogic.xbee.api.RemoteAtRequest;
import com.rapplogic.xbee.api.RemoteAtResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.XBeeTimeoutException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class RemoteAtExample {
    private static final Logger log = Logger.getLogger(RemoteAtExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteAtExample() throws XBeeException, InterruptedException {
        block10: {
            XBee xbee = new XBee();
            try {
                xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
                XBeeAddress64 addr64 = new XBeeAddress64(0, 19, 162, 0, 64, 10, 62, 2);
                RemoteAtRequest request = new RemoteAtRequest(addr64, "P0", new int[]{1});
                RemoteAtResponse response = (RemoteAtResponse)xbee.sendSynchronous(request, 10000);
                if (!response.isOk()) {
                    throw new RuntimeException("failed to turn on pin 20.  status is " + (Object)((Object)response.getStatus()));
                }
                log.info((Object)"successfully turned on pin 20 (D0)");
                System.exit(0);
                Thread.sleep(5000L);
                request.setValue(new int[]{4});
                response = (RemoteAtResponse)xbee.sendSynchronous(request, 10000);
                if (response.isOk()) {
                    log.info((Object)"successfully turned off pin 20 (D0)");
                    break block10;
                }
                throw new RuntimeException("failed to turn off pin 20.  status is " + (Object)((Object)response.getStatus()));
            }
            catch (XBeeTimeoutException e) {
                log.error((Object)"request timed out. make sure you remote XBee is configured and powered on");
            }
            catch (Exception e) {
                log.error((Object)"unexpected error", (Throwable)e);
            }
            finally {
                if (xbee != null && xbee.isConnected()) {
                    xbee.close();
                }
            }
        }
    }

    public static void main(String[] args) throws XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new RemoteAtExample();
    }
}

