/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.wpan;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.ErrorResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.wpan.RxResponse16;
import com.rapplogic.xbee.api.wpan.RxResponse64;
import com.rapplogic.xbee.util.ByteUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ApiReceiverExample {
    private static final Logger log = Logger.getLogger(ApiReceiverExample.class);
    private long last = System.currentTimeMillis();

    private ApiReceiverExample() throws Exception {
        XBee xbee = new XBee();
        int count = 0;
        int errors = 0;
        try {
            xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
            while (true) {
                try {
                    while (true) {
                        XBeeResponse response = xbee.getResponse();
                        ++count;
                        if (response.isError()) {
                            log.info((Object)"response contains errors", (Throwable)((ErrorResponse)response).getException());
                            ++errors;
                        }
                        for (int i = 0; i < response.getPacketBytes().length; ++i) {
                            log.info((Object)("packet [" + i + "] " + ByteUtils.toBase16(response.getPacketBytes()[i])));
                        }
                        if (response.getApiId() == ApiId.RX_16_RESPONSE) {
                            log.info((Object)("Received RX 16 packet " + (RxResponse16)response));
                        } else if (response.getApiId() == ApiId.RX_64_RESPONSE) {
                            log.info((Object)("Received RX 64 packet " + (RxResponse64)response));
                        } else {
                            log.info((Object)("Ignoring mystery packet " + response.toString()));
                        }
                        log.debug((Object)("Received response: " + response.toString() + ", count is " + count + ", errors is " + errors));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ApiReceiverExample();
    }
}

