/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.wpan;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeePacket;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.wpan.TxRequest16;
import com.rapplogic.xbee.api.wpan.TxStatusResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ApiSenderExample {
    private static final Logger log = Logger.getLogger(ApiSenderExample.class);

    private ApiSenderExample() throws Exception {
        XBee xbee = new XBee();
        int sleep = 5000;
        int count = 0;
        int errors = 0;
        int ackErrors = 0;
        int ccaErrors = 0;
        int purgeErrors = 0;
        try {
            xbee.open("/dev/tty.usbserial-A6005uPi", 9600);
            while (true) {
                int[] payload = new int[]{XBeePacket.SpecialByte.START_BYTE.getValue()};
                XBeeAddress16 destination = new XBeeAddress16(24, 116);
                TxRequest16 tx = new TxRequest16(destination, payload);
                long now = System.currentTimeMillis();
                xbee.sendAsynchronous(tx);
                XBeeResponse response = null;
                while ((response = xbee.getResponse()).getApiId() != ApiId.TX_STATUS_RESPONSE) {
                    log.debug((Object)("expected tx status but received " + response));
                }
                if (((TxStatusResponse)response).getFrameId() != tx.getFrameId()) {
                    throw new RuntimeException("frame id does not match");
                }
                if (((TxStatusResponse)response).getStatus() != TxStatusResponse.Status.SUCCESS) {
                    ++errors;
                    if (((TxStatusResponse)response).isAckError()) {
                        ++ackErrors;
                    } else if (((TxStatusResponse)response).isCcaError()) {
                        ++ccaErrors;
                    } else if (((TxStatusResponse)response).isPurged()) {
                        ++purgeErrors;
                    }
                    log.debug((Object)("Tx status failure with status: " + (Object)((Object)((TxStatusResponse)response).getStatus())));
                } else {
                    log.debug((Object)("Success.  count is " + count + ", errors is " + errors + ", in " + (System.currentTimeMillis() - now) + ", ack errors " + ackErrors + ", ccaErrors " + ccaErrors + ", purge errors " + purgeErrors));
                }
                ++count;
                Thread.sleep(5000L);
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ApiSenderExample();
    }
}

