/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.wpan;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.ErrorResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.wpan.IoSample;
import com.rapplogic.xbee.api.wpan.RxResponseIoSample;
import com.rapplogic.xbee.util.ByteUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class IoSamplesExample {
    private static final Logger log = Logger.getLogger(IoSamplesExample.class);

    private IoSamplesExample() throws Exception {
        XBee xbee = new XBee();
        try {
            xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
            while (true) {
                try {
                    block5: while (true) {
                        XBeeResponse response = xbee.getResponse();
                        log.info((Object)("Received i/o response: " + response));
                        log.info((Object)("packet bytes is " + ByteUtils.toBase16(response.getPacketBytes())));
                        if (response.isError()) {
                            log.info((Object)"response contains errors", (Throwable)((ErrorResponse)response).getException());
                            continue;
                        }
                        if (response.getApiId() == ApiId.RX_16_IO_RESPONSE) {
                            RxResponseIoSample ioSample = (RxResponseIoSample)response;
                            log.info((Object)("Received I/O sample from " + ioSample.getSourceAddress()));
                            IoSample[] ioSampleArray = ioSample.getSamples();
                            int n = ioSampleArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block5;
                                IoSample sample = ioSampleArray[n2];
                                if (ioSample.containsAnalog()) {
                                    log.info((Object)("Analog pin 20 10-bit reading is " + sample.getAnalog0()));
                                    log.info((Object)("Digital pin 11 is " + (sample.isD4On() != false ? "on" : "off")));
                                    log.info((Object)("Digital pin 12 is " + (sample.isD7On() != false ? "on" : "off")));
                                } else {
                                    log.info((Object)("Received change detect for Digital pin 12: " + (sample.isD7On() != false ? "on" : "off")));
                                }
                                ++n2;
                            }
                        }
                        log.info((Object)("Ignoring mystery packet " + response.toString()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        new IoSamplesExample();
    }
}

