/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.wpan;

import com.rapplogic.xbee.api.PacketListener;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.wpan.RxResponseIoSample;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.PropertyConfigurator;

public class Processing {
    XBee xbee;
    Queue<XBeeResponse> queue = new ConcurrentLinkedQueue<XBeeResponse>();
    boolean message;
    XBeeResponse response;

    void setup() {
        try {
            PropertyConfigurator.configure((String)(this.dataPath("") + "log4j.properties"));
            this.xbee = new XBee();
            this.xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
            this.xbee.addPacketListener(new PacketListener(){

                @Override
                public void processResponse(XBeeResponse response) {
                    Processing.this.queue.offer(response);
                }
            });
        }
        catch (Exception e) {
            System.out.println("XBee failed to initialize");
            e.printStackTrace();
            System.exit(1);
        }
    }

    void draw() {
        try {
            this.readPackets();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void readPackets() throws Exception {
        while ((this.response = this.queue.poll()) != null) {
            try {
                RxResponseIoSample ioSample = (RxResponseIoSample)this.response;
                this.println("We received a sample from " + ioSample.getSourceAddress());
                if (!ioSample.containsAnalog()) continue;
                this.println("10-bit temp reading (pin 19) is " + ioSample.getSamples()[0].getAnalog1());
            }
            catch (ClassCastException classCastException) {}
        }
    }

    void println(String s) {
    }

    String dataPath(String s) {
        return null;
    }
}

