/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.wpan;

import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.CollectTerminator;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.wpan.WpanNodeDiscover;
import com.rapplogic.xbee.util.ByteUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class WpanNodeDiscoverExample {
    private static final Logger log = Logger.getLogger(WpanNodeDiscoverExample.class);
    private XBee xbee = new XBee();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WpanNodeDiscoverExample() throws XBeeException, InterruptedException {
        try {
            this.xbee.open("/dev/tty.usbserial-A4004Rim", 9600);
            this.xbee.sendAsynchronous(new AtCommand("NT"));
            AtCommandResponse nodeTimeout = (AtCommandResponse)this.xbee.getResponse();
            int nodeDiscoveryTimeout = ByteUtils.convertMultiByteToInt(nodeTimeout.getValue()) * 100;
            log.info((Object)("Node discovery timeout is " + nodeDiscoveryTimeout + " milliseconds"));
            this.xbee.sendAsynchronous(new AtCommand("ND"));
            List<? extends XBeeResponse> responses = this.xbee.collectResponses(10000, new CollectTerminator(){

                @Override
                public boolean stop(XBeeResponse response) {
                    AtCommandResponse at;
                    if (response instanceof AtCommandResponse && (at = (AtCommandResponse)response).getCommand().equals("ND") && at.getValue() != null && at.getValue().length == 0) {
                        log.debug((Object)"Found terminating response");
                        return true;
                    }
                    return false;
                }
            });
            log.info((Object)"Time is up!  You should have heard back from all nodes by now.  If not make sure all nodes are associated and/or try increasing the node timeout (NT)");
            for (XBeeResponse xBeeResponse : responses) {
                AtCommandResponse atResponse;
                if (!(xBeeResponse instanceof AtCommandResponse) || !(atResponse = (AtCommandResponse)xBeeResponse).getCommand().equals("ND") || atResponse.getValue() == null || atResponse.getValue().length <= 0) continue;
                WpanNodeDiscover nd = WpanNodeDiscover.parse((AtCommandResponse)xBeeResponse);
                log.info((Object)("Node Discover is " + nd));
            }
        }
        finally {
            if (this.xbee != null && this.xbee.isConnected()) {
                this.xbee.close();
            }
        }
    }

    public static void main(String[] args) throws XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new WpanNodeDiscoverExample();
    }
}

