/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.zigbee.ZNetTxRequest;
import com.rapplogic.xbee.util.ByteUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class BroadcastSenderExample {
    private static final Logger log = Logger.getLogger(BroadcastSenderExample.class);

    private BroadcastSenderExample() throws XBeeException {
        XBee xbee = new XBee();
        try {
            xbee.open("/dev/ttyUSB0", 9600);
            while (true) {
                int[] payload = ByteUtils.stringToIntArray("the\nquick\nbrown\nfox");
                ZNetTxRequest request = new ZNetTxRequest(XBeeAddress64.BROADCAST, payload);
                request.setOption(ZNetTxRequest.Option.BROADCAST);
                log.info((Object)("request packet bytes (base 16) " + ByteUtils.toBase16(request.getXBeePacket().getPacket())));
                xbee.sendAsynchronous(request);
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new BroadcastSenderExample();
    }
}

