/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.RemoteAtRequest;
import com.rapplogic.xbee.api.RemoteAtResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeConfiguration;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.XBeeTimeoutException;
import com.rapplogic.xbee.examples.zigbee.ZNetSenderExample;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SleepTestCoordinator {
    private static final Logger log = Logger.getLogger(ZNetSenderExample.class);

    public SleepTestCoordinator(String[] args) throws XBeeTimeoutException, XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        XBee xbee = new XBee(new XBeeConfiguration().withStartupChecks(false));
        xbee.open("/dev/tty.usbserial-A6005uRz", 9600);
        XBeeAddress64 addr64 = new XBeeAddress64(0, 19, 162, 0, 64, 10, 62, 2);
        if (args.length == 1 && (args[0].equals("on") || args[0].equals("off"))) {
            log.info((Object)("Turning D0 " + args[0]));
            RemoteAtRequest request = new RemoteAtRequest(addr64, "D0", new int[]{args[0].equals("on") ? 5 : 4});
            RemoteAtResponse response = (RemoteAtResponse)xbee.sendSynchronous(request, 15000);
            if (response.isOk()) {
                log.info((Object)("Successfully turned " + args[0] + " pin 20 (D0)"));
            } else {
                log.warn((Object)("Failed to turn " + args[0] + " pin 20.  status is " + (Object)((Object)response.getStatus())));
            }
            Thread.sleep(2000L);
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
        } else {
            System.err.println("arg should be on or off");
        }
    }

    public static void main(String[] args) throws XBeeTimeoutException, XBeeException, InterruptedException {
        new SleepTestCoordinator(args);
    }
}

