/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.RemoteAtResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.XBeeTimeoutException;
import com.rapplogic.xbee.api.zigbee.ZBForceSampleRequest;
import com.rapplogic.xbee.api.zigbee.ZNetRxIoSampleResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZBForceSampleExample {
    private static final Logger log = Logger.getLogger(ZBForceSampleExample.class);

    private ZBForceSampleExample() throws Exception {
        XBee xbee = new XBee();
        try {
            xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
            while (true) {
                XBeeAddress64 addr64 = new XBeeAddress64(0, 19, 162, 0, 64, 10, 62, 2);
                ZBForceSampleRequest request = new ZBForceSampleRequest(addr64);
                try {
                    XBeeResponse response = xbee.sendSynchronous(request, 6000);
                    RemoteAtResponse remoteAt = (RemoteAtResponse)response;
                    if (remoteAt.isOk()) {
                        ZNetRxIoSampleResponse ioSample = ZNetRxIoSampleResponse.parseIsSample(remoteAt);
                        log.info((Object)("10 bit analog1 sample is " + ioSample.getAnalog1()));
                    } else {
                        log.info((Object)("Remote AT request failed: " + response));
                    }
                }
                catch (XBeeTimeoutException e) {
                    log.info((Object)"request timed out");
                }
                Thread.sleep(2000L);
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZBForceSampleExample();
    }
}

