/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZBNodeDiscover;
import com.rapplogic.xbee.util.ByteUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZBNodeDiscoverExample {
    private static final Logger log = Logger.getLogger(ZBNodeDiscoverExample.class);
    private XBee xbee = new XBee();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZBNodeDiscoverExample() throws XBeeException, InterruptedException {
        try {
            this.xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
            this.xbee.sendAsynchronous(new AtCommand("NT"));
            AtCommandResponse nodeTimeout = (AtCommandResponse)this.xbee.getResponse();
            int nodeDiscoveryTimeout = ByteUtils.convertMultiByteToInt(nodeTimeout.getValue()) * 100;
            log.info((Object)("Node discovery timeout is " + nodeDiscoveryTimeout + " milliseconds"));
            log.info((Object)"Sending Node Discover command");
            this.xbee.sendAsynchronous(new AtCommand("ND"));
            List<? extends XBeeResponse> responses = this.xbee.collectResponses(nodeDiscoveryTimeout);
            log.info((Object)"Time is up!  You should have heard back from all nodes by now.  If not make sure all nodes are associated and/or try increasing the node timeout (NT)");
            for (XBeeResponse xBeeResponse : responses) {
                AtCommandResponse atResponse;
                if (!(xBeeResponse instanceof AtCommandResponse) || !(atResponse = (AtCommandResponse)xBeeResponse).getCommand().equals("ND") || atResponse.getValue() == null || atResponse.getValue().length <= 0) continue;
                ZBNodeDiscover nd = ZBNodeDiscover.parse((AtCommandResponse)xBeeResponse);
                log.info((Object)("Node Discover is " + nd));
            }
        }
        finally {
            if (this.xbee != null && this.xbee.isConnected()) {
                this.xbee.close();
            }
        }
    }

    public static void main(String[] args) throws XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZBNodeDiscoverExample();
    }
}

