/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.zigbee.AssociationStatus;
import com.rapplogic.xbee.util.ByteUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZNetApiAtExample {
    private static final Logger log = Logger.getLogger(ZNetApiAtExample.class);
    private XBee xbee = new XBee();

    public ZNetApiAtExample() throws XBeeException {
        try {
            this.xbee.open("COM6", 9600);
            log.debug((Object)("SH is " + ByteUtils.toBase16(this.xbee.sendAtCommand(new AtCommand("SH")).getValue())));
            log.debug((Object)("SL is " + ByteUtils.toBase16(this.xbee.sendAtCommand(new AtCommand("SL")).getValue())));
        }
        finally {
            if (this.xbee != null && this.xbee.isConnected()) {
                this.xbee.close();
            }
        }
    }

    private void associationStatus(XBee xbee) throws XBeeException {
        AtCommandResponse response = xbee.sendAtCommand(new AtCommand("AI"));
        log.debug((Object)("Association Status is " + (Object)((Object)AssociationStatus.get(response))));
    }

    private void configureEndDevice(XBee xbee) throws XBeeException {
        AtCommandResponse response = null;
        response = xbee.sendAtCommand(new AtCommand("RE"));
        log.debug((Object)("RE is " + response));
        response = xbee.sendAtCommand(new AtCommand("ID", new int[]{26, 170}));
        log.debug((Object)("ID is " + response));
        response = xbee.sendAtCommand(new AtCommand("NI", new int[]{69, 78, 68, 95, 68, 69, 86, 73, 67, 69, 95, 50}));
        log.debug((Object)("NI is " + response));
        response = xbee.sendAtCommand(new AtCommand("AP", 2));
        log.debug((Object)("AP is " + response));
        response = xbee.sendAtCommand(new AtCommand("WR"));
        log.debug((Object)("WR is " + response));
        response = xbee.sendAtCommand(new AtCommand("FR"));
        log.debug((Object)("FR is " + response));
    }

    private void configureCoordinator(XBee xbee) throws XBeeException {
        AtCommandResponse response = null;
        response = xbee.sendAtCommand(new AtCommand("RE"));
        log.debug((Object)("RE is " + response));
        response = xbee.sendAtCommand(new AtCommand("ID", new int[]{26, 170}));
        log.debug((Object)("RE is " + response));
        response = xbee.sendAtCommand(new AtCommand("NI", new int[]{67, 79, 79, 82, 68, 73, 78, 65, 84, 79, 82}));
        log.debug((Object)("NI is " + response));
        response = xbee.sendAtCommand(new AtCommand("AP", 2));
        log.debug((Object)("AP is " + response));
        response = xbee.sendAtCommand(new AtCommand("WR"));
        log.debug((Object)("WR is " + response));
        response = xbee.sendAtCommand(new AtCommand("FR"));
        log.debug((Object)("FR is " + response));
    }

    private void configureIOSamples(XBee xbee) throws XBeeException {
        AtCommandResponse response = null;
        response = xbee.sendAtCommand(new AtCommand("IR", new int[]{39, 16}));
        log.debug((Object)("IR is " + response));
        response = xbee.sendAtCommand(new AtCommand("DO", 3));
        log.debug((Object)("DO is " + response));
        response = xbee.sendAtCommand(new AtCommand("D1", 2));
        log.debug((Object)("D1 is " + response));
        response = xbee.sendAtCommand(new AtCommand("D2", 2));
        log.debug((Object)("D2 is " + response));
        response = xbee.sendAtCommand(new AtCommand("D6", 3));
        log.debug((Object)("D6 is " + response));
    }

    public static void main(String[] args) throws XBeeException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZNetApiAtExample();
    }
}

