/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZNetExplicitRxResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZNetExplicitReceiverExample {
    private static final Logger log = Logger.getLogger(ZNetExplicitReceiverExample.class);

    private ZNetExplicitReceiverExample() throws Exception {
        XBee xbee = new XBee();
        try {
            xbee.open("/dev/tty.usbserial-A6005uRz", 9600);
            while (true) {
                try {
                    while (true) {
                        XBeeResponse response;
                        if ((response = xbee.getResponse()).getApiId() == ApiId.ZNET_EXPLICIT_RX_RESPONSE) {
                            ZNetExplicitRxResponse rx = (ZNetExplicitRxResponse)response;
                            log.info((Object)("received explicit packet response " + response.toString()));
                            continue;
                        }
                        log.debug((Object)("received unexpected packet " + response.toString()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZNetExplicitReceiverExample();
    }
}

