/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZNetExplicitTxRequest;
import com.rapplogic.xbee.api.zigbee.ZNetTxRequest;
import com.rapplogic.xbee.util.DoubleByte;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZNetExplicitSenderExample {
    private static final Logger log = Logger.getLogger(ZNetExplicitSenderExample.class);

    private ZNetExplicitSenderExample() throws XBeeException {
        XBee xbee = new XBee();
        try {
            xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
            XBeeAddress64 addr64 = new XBeeAddress64(0, 19, 162, 0, 64, 10, 62, 2);
            int[] payload = new int[]{0, 102, 238};
            int sourceEndpoint = 0;
            int destinationEndpoint = ZNetExplicitTxRequest.Endpoint.DATA.getValue();
            DoubleByte clusterId = new DoubleByte(0, ZNetExplicitTxRequest.ClusterId.SERIAL_LOOPBACK.getValue());
            ZNetExplicitTxRequest request = new ZNetExplicitTxRequest(255, addr64, XBeeAddress16.ZNET_BROADCAST, 0, ZNetTxRequest.Option.UNICAST, payload, sourceEndpoint, destinationEndpoint, clusterId, ZNetExplicitTxRequest.znetProfileId);
            log.info((Object)("sending explicit " + request.toString()));
            while (true) {
                xbee.sendAsynchronous(request);
                XBeeResponse response = xbee.getResponse();
                log.info((Object)("received response " + response.toString()));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZNetExplicitSenderExample();
    }
}

