/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.PacketListener;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZNetRxIoSampleResponse;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZNetIoSampleExample
implements PacketListener {
    private static final Logger log = Logger.getLogger(ZNetIoSampleExample.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZNetIoSampleExample() throws Exception {
        XBee xbee = new XBee();
        try {
            xbee.open("/dev/tty.usbserial-A6005v5M", 9600);
            xbee.addPacketListener(this);
            ZNetIoSampleExample zNetIoSampleExample = this;
            synchronized (zNetIoSampleExample) {
                this.wait();
            }
        }
        finally {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
        }
    }

    @Override
    public void processResponse(XBeeResponse response) {
        if (response.getApiId() == ApiId.ZNET_IO_SAMPLE_RESPONSE) {
            ZNetRxIoSampleResponse ioSample = (ZNetRxIoSampleResponse)response;
            log.debug((Object)("received i/o sample packet.  contains analog is " + ioSample.containsAnalog() + ", contains digital is " + ioSample.containsDigital()));
            log.debug((Object)("pin 20 (DO) digital is " + ioSample.isD0On()));
            log.debug((Object)("pin 19 (D1) analog is " + ioSample.getAnalog1()));
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZNetIoSampleExample();
    }
}

