/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.zigbee.ZNetRxResponse;
import com.rapplogic.xbee.util.ByteUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZNetReceiverExample {
    private static final Logger log = Logger.getLogger(ZNetReceiverExample.class);

    private ZNetReceiverExample() throws Exception {
        XBee xbee = new XBee();
        try {
            xbee.open("/dev/tty.usbserial-A6005uPi", 9600);
            while (true) {
                try {
                    while (true) {
                        XBeeResponse response = xbee.getResponse();
                        log.info((Object)("received response " + response.toString()));
                        if (response.getApiId() == ApiId.ZNET_RX_RESPONSE) {
                            ZNetRxResponse rx = (ZNetRxResponse)response;
                            log.info((Object)("Received RX packet, option is " + (Object)((Object)rx.getOption()) + ", sender 64 address is " + ByteUtils.toBase16(rx.getRemoteAddress64().getAddress()) + ", remote 16-bit address is " + ByteUtils.toBase16(rx.getRemoteAddress16().getAddress()) + ", data is " + ByteUtils.toBase16(rx.getData())));
                            AtCommand at = new AtCommand("DB");
                            xbee.sendAsynchronous(at);
                            XBeeResponse atResponse = xbee.getResponse();
                            if (atResponse.getApiId() == ApiId.AT_RESPONSE) {
                                log.info((Object)("RSSI of last response is " + -((AtCommandResponse)atResponse).getValue()[0]));
                                continue;
                            }
                            log.info((Object)("expected RSSI, but received " + atResponse.toString()));
                            continue;
                        }
                        log.debug((Object)("received unexpected packet " + response.toString()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (xbee != null && xbee.isConnected()) {
                xbee.close();
            }
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZNetReceiverExample();
    }
}

