/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.examples.zigbee;

import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.XBeeTimeoutException;
import com.rapplogic.xbee.api.zigbee.ZNetTxRequest;
import com.rapplogic.xbee.api.zigbee.ZNetTxStatusResponse;
import com.rapplogic.xbee.util.ByteUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ZNetSenderExample {
    private static final Logger log = Logger.getLogger(ZNetSenderExample.class);

    private ZNetSenderExample() throws XBeeException {
        XBee xbee = new XBee();
        xbee.open("/dev/tty.usbserial-A6005uRz", 9600);
        XBeeAddress64 addr64 = new XBeeAddress64(0, 19, 162, 0, 64, 139, 152, 255);
        int[] payload = new int[]{88, 66, 101, 101};
        ZNetTxRequest request = new ZNetTxRequest(addr64, payload);
        log.debug((Object)("zb request is " + request.getXBeePacket().getPacket()));
        log.info((Object)("sending tx " + request));
        while (true) {
            log.info((Object)("request packet bytes (base 16) " + ByteUtils.toBase16(request.getXBeePacket().getPacket())));
            long start = System.currentTimeMillis();
            try {
                ZNetTxStatusResponse response = (ZNetTxStatusResponse)xbee.sendSynchronous(request, 10000);
                request.setFrameId(xbee.getNextFrameId());
                log.info((Object)("received response " + response));
                if (response.getDeliveryStatus() == ZNetTxStatusResponse.DeliveryStatus.SUCCESS) {
                    if (response.getRemoteAddress16().equals(XBeeAddress16.ZNET_BROADCAST)) {
                        request.setDestAddr16(response.getRemoteAddress16());
                    }
                } else {
                    log.error((Object)("packet failed due to error: " + (Object)((Object)response.getDeliveryStatus())));
                }
                log.info((Object)("Response in " + (System.currentTimeMillis() - start) + ", Delivery status is " + (Object)((Object)response.getDeliveryStatus()) + ", 16-bit address is " + ByteUtils.toBase16(response.getRemoteAddress16().getAddress()) + ", retry count is " + response.getRetryCount() + ", discovery status is " + (Object)((Object)response.getDeliveryStatus())));
            }
            catch (XBeeTimeoutException e) {
                log.warn((Object)"request timed out");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public static void main(String[] args) throws XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new ZNetSenderExample();
    }
}

