/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.socket;

import com.rapplogic.xbee.AbstractXBeeConnection;
import com.rapplogic.xbee.socket.ServerNotAvailableException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

public class SocketXBeeConnection
extends AbstractXBeeConnection {
    private static final Logger log = Logger.getLogger(SocketXBeeConnection.class);
    private Socket socket;
    private XBeeSocketOutputStream xBeeSocketOutputStream;
    private OutputStream out;
    private ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(false);
            return thread;
        }
    });

    public SocketXBeeConnection(String host, Integer port) throws ServerNotAvailableException {
        this.init(host, port);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.xBeeSocketOutputStream;
    }

    private void init(String host, Integer port) throws ServerNotAvailableException {
        Socket socket;
        try {
            socket = new Socket(host, (int)port);
            log.info((Object)"Successfully connected to socket server");
        }
        catch (IOException e) {
            log.warn((Object)("Unable to connect to host:port " + host + ":" + port));
            throw new ServerNotAvailableException("Unable to connect to host:port " + host + ":" + port, e);
        }
        try {
            this.out = socket.getOutputStream();
            this.xBeeSocketOutputStream = new XBeeSocketOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Outputstream not available for socket", e);
        }
        try {
            socket.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Inputstream not available for socket", e);
        }
        this.socket = socket;
        this.pipeSocketInputStreamToXBee();
    }

    private void pipeSocketInputStreamToXBee() {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                int b = 0;
                try {
                    while ((b = SocketXBeeConnection.this.socket.getInputStream().read()) != -1) {
                        SocketXBeeConnection.this.pipeToInputStream(b);
                    }
                    log.debug((Object)"End of socket input stream.. exiting");
                }
                catch (IOException e) {
                    log.warn((Object)("Error reading from socket input stream " + e.toString() + "... closing socket"));
                    SocketXBeeConnection.this.tryClose();
                }
                catch (Throwable t) {
                    log.error((Object)"Error reading from input  to the xbee output stream", t);
                    try {
                        SocketXBeeConnection.this.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private String socketStatus() {
        return "isConnected: " + this.socket.isConnected() + ", isBound: " + this.socket.isBound() + ", isClosed: " + this.socket.isClosed();
    }

    private void tryClose() {
        try {
            log.info((Object)"Closing socket");
            this.close();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to close socket " + e.toString()));
        }
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
        this.executorService.shutdownNow();
    }

    public class XBeeSocketOutputStream
    extends OutputStream {
        @Override
        public void write(int i) throws IOException {
            try {
                SocketXBeeConnection.this.out.write(i);
            }
            catch (IOException e) {
                log.warn((Object)("Failed to write byte " + i + " to output stream. closing socket. error: " + e.toString() + ", socket " + SocketXBeeConnection.this.socketStatus()));
                SocketXBeeConnection.this.tryClose();
                throw e;
            }
        }
    }
}

