/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.socket;

import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeConfiguration;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.socket.SocketXBeeConnection;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SocketXBeeExample {
    private static final Logger log = Logger.getLogger(SocketXBeeExample.class);

    public static void main(String[] args) throws UnknownHostException, XBeeException, IOException {
        PropertyConfigurator.configure((String)"log4j.properties");
        try {
            XBee xbee = new XBee(new XBeeConfiguration().withStartupChecks(false));
            xbee.initProviderConnection(new SocketXBeeConnection("pi", 9000));
            for (int i = 0; i < 3; ++i) {
                block5: {
                    log.debug((Object)"Sending AI command");
                    try {
                        AtCommandResponse response = (AtCommandResponse)xbee.sendSynchronous(new AtCommand("AI"));
                        log.debug((Object)("Received AI response " + response));
                    }
                    catch (XBeeException e) {
                        if (e.getCause() == null || !(e.getCause() instanceof SocketException)) break block5;
                        throw e;
                    }
                }
                Thread.sleep(1000L);
            }
            log.debug((Object)"Done");
        }
        catch (Throwable t) {
            log.error((Object)"xbee socket client failed", t);
        }
    }
}

