/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.test;

import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.XBee;
import com.rapplogic.xbee.api.XBeeException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class OpenCloseConnectionsTest {
    private static final Logger log = Logger.getLogger(OpenCloseConnectionsTest.class);
    private XBee xbee = new XBee();

    public static void main(String[] args) throws XBeeException, InterruptedException {
        PropertyConfigurator.configure((String)"log4j.properties");
        new OpenCloseConnectionsTest();
    }

    public OpenCloseConnectionsTest() throws XBeeException, InterruptedException {
        String device = "/dev/tty.usbserial-A4004Rim";
        log.info((Object)"opening connection");
        this.xbee.open(device, 9600);
        if (!this.xbee.isConnected()) {
            throw new RuntimeException("Should be connected");
        }
        try {
            log.info((Object)"attempting duplicate open");
            this.xbee.open(device, 9600);
            throw new RuntimeException("fail -- already open");
        }
        catch (Exception e) {
            log.debug((Object)"Expected", (Throwable)e);
            log.info((Object)"sending channel command");
            if (!this.xbee.sendAtCommand(new AtCommand("CH")).isOk()) {
                throw new RuntimeException("fail");
            }
            log.info((Object)"closing connection");
            this.xbee.close();
            if (this.xbee.isConnected()) {
                throw new RuntimeException("Should be disconnected");
            }
            try {
                log.info((Object)"sending at command, but we're disconnected");
                this.xbee.sendAtCommand(new AtCommand("CH")).isOk();
                throw new RuntimeException("Should be disconnected");
            }
            catch (Exception e2) {
                log.debug((Object)"Expected", (Throwable)e2);
                log.info((Object)"reconnecting");
                this.xbee.open(device, 9600);
                if (!this.xbee.sendAtCommand(new AtCommand("CH")).isOk()) {
                    throw new RuntimeException("fail");
                }
                log.info((Object)"closing conn");
                this.xbee.close();
                try {
                    log.info((Object)"try duplicate close");
                    this.xbee.close();
                    throw new RuntimeException("Already closed");
                }
                catch (Exception e3) {
                    log.debug((Object)"Expected", (Throwable)e3);
                    return;
                }
            }
        }
    }
}

