/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.util;

import com.rapplogic.xbee.util.IIntInputStream;
import java.io.IOException;

public class ByteUtils {
    private ByteUtils() {
    }

    public static int convertMultiByteToInt(int[] bytes) {
        if (bytes.length > 4) {
            throw new RuntimeException("too big");
        }
        if (bytes.length == 4 && (bytes[0] & 0x80) == 128) {
            throw new IllegalArgumentException("Java int can't support a four byte value with msb byte greater than 7e");
        }
        int val = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] > 255) {
                throw new IllegalArgumentException("Values exceeds byte range: " + bytes[i]);
            }
            if (i == bytes.length - 1) {
                val += bytes[i];
                continue;
            }
            val += bytes[i] << (bytes.length - i - 1) * 8;
        }
        return val;
    }

    public static int[] convertInttoMultiByte(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Negative values are not supported");
        }
        int size = 0;
        size = val >> 24 > 0 ? 4 : (val >> 16 > 0 ? 3 : (val >> 8 > 0 ? 2 : 1));
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = val >> (size - i - 1) * 8 & 0xFF;
        }
        return data;
    }

    public static String toBase16(int[] arr) {
        return ByteUtils.toBase16(arr, ",");
    }

    public static String toBase16(int[] arr, String delimiter) {
        if (arr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(ByteUtils.toBase16(arr[i]));
            if (i >= arr.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String toBase2(int[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(ByteUtils.toBase2(arr[i]));
            if (i >= arr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String toBase10(int[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]);
            if (i >= arr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String toChar(int[] arr) {
        return ByteUtils.toString(arr);
    }

    public static String toString(int[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int anArr : arr) {
            sb.append((char)anArr);
        }
        return sb.toString();
    }

    private static String padBase2(String s) {
        for (int i = s.length(); i < 8; ++i) {
            s = "0" + s;
        }
        return s;
    }

    public static boolean getBit(int b, int position) {
        if (position < 1 || position > 8) {
            throw new IllegalArgumentException("Position is out of range");
        }
        if (b > 255) {
            throw new IllegalArgumentException("input value [" + b + "] is larger than a byte");
        }
        return (b >> --position & 1) == 1;
    }

    public static String toBase16(int b) {
        if (b > 255) {
            throw new IllegalArgumentException("input value [" + b + "] is larger than a byte");
        }
        if (b < 16) {
            return "0x0" + Integer.toHexString(b);
        }
        return "0x" + Integer.toHexString(b);
    }

    public static String toBase2(int b) {
        if (b > 255) {
            throw new IllegalArgumentException("input value [" + b + "] is larger than a byte");
        }
        return ByteUtils.padBase2(Integer.toBinaryString(b));
    }

    public static String formatByte(int b) {
        return "base10=" + Integer.toString(b) + ",base16=" + ByteUtils.toBase16(b) + ",base2=" + ByteUtils.toBase2(b);
    }

    public static int[] stringToIntArray(String s) {
        int[] intArr = new int[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            intArr[i] = s.charAt(i);
        }
        return intArr;
    }

    public static int parse10BitAnalog(int msb, int lsb) throws IOException {
        msb &= 0xFF;
        msb = (msb & 3) << 8;
        return msb + (lsb &= 0xFF);
    }

    public static int parse10BitAnalog(IIntInputStream in, int pos) throws IOException {
        int adcMsb = in.read("Analog " + pos + " MSB");
        int adcLsb = in.read("Analog " + pos + " LSB");
        return ByteUtils.parse10BitAnalog(adcMsb, adcLsb);
    }
}

