/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.util;

public class DoubleByte {
    private int msb;
    private int lsb;

    public DoubleByte() {
    }

    public DoubleByte(int val) {
        if (val > 65535 || val < 0) {
            throw new IllegalArgumentException("value is out of range");
        }
        this.msb = val >> 8;
        this.lsb = val & 0xFF;
    }

    public DoubleByte(int msb, int lsb) {
        if (msb > 255 || lsb > 255) {
            throw new IllegalArgumentException("msb or lsb are out of range");
        }
        this.msb = msb;
        this.lsb = lsb;
    }

    public int getMsb() {
        return this.msb;
    }

    public int getLsb() {
        return this.lsb;
    }

    public int get16BitValue() {
        return (this.msb << 8) + this.lsb;
    }

    public void setMsb(int msb) {
        this.msb = msb;
    }

    public void setLsb(int lsb) {
        this.lsb = lsb;
    }

    public int[] getArray() {
        return new int[]{this.msb, this.lsb};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleByte that = (DoubleByte)o;
        if (this.lsb != that.lsb) {
            return false;
        }
        return this.msb == that.msb;
    }

    public int hashCode() {
        int result = this.msb;
        result = 31 * result + this.lsb;
        return result;
    }
}

